//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.11 page-736
//Topic      : Flow Measurement and Control by Weirs
//Caption    : A weir in a horizontal channel

//===================================================
package Ex10_11
extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex10_11_a

//Parameter
parameter Real Y(unit="m") = 1      "Channel height";
parameter Real b(unit="m") = 4      "Channel width";
parameter Real y1(unit="m") = 1.6   "Upstream depth";
parameter Real L(unit="m") = 1.2    "Crest length";
parameter Real v(unit="m^2/s") = 0.00000098823 "Kinematic viscosity";
parameter Real V1b(unit="m/s") = 0.5 "Velocity-Round nosed weir";

//DATA: Table 10.57
parameter Real e(unit="mm") = 2.4 "Roughness height";

//===================================================
//Variable 

Real Cd(unit="-")   "Weir dicharge coefficient";
Real H(unit="m")    "Blockage height";
Real Q(unit="m^3/s") "Discharge";
Real V1(unit="m/s") "Upstream velocity";
Real rey(unit="-")  "Reynolds number";

//===================================================
//Equation

equation

//USING: Eq.10.56
H+Y=y1;
Cd=0.564+(0.0846*(H/Y));

//USING: Eq.10.55
Q=(Cd*b)*(g^0.5)*(H^(3/2));

// H/Y = 06 < 2
V1=(Q/(b*y1));
rey=(V1*H/v);

end Ex10_11_a;
//===================================================

model Ex10_11_b
extends Ex10_11_a;

//===================================================

//FOR: round nosed broad crested weir
//Variable

Real s(unit="-")    "Displacement thickness-round nosed crested weir";
Real Cdb(unit="-")  "Discharge coefficient-round nosed crested weir";
Real Qb(unit="m^3/s")   "Discharge rate-round nosed crested weir";
Real reyb(unit="-")     "Reynolds number-round nosed crested weir";
Real x(unit="m")        "Length difference -round nosed crested weir";

//===================================================

//Equation

equation

//USING: Eq10.57
s=0.001+(0.2)*(((e/1000)/L)^0.5);
Cdb=(0.544)*((1-(s/(H/L)))^(3/2));
Qb=(Cdb*b)*(g^0.5)*(H^1.5);
reyb=(V1b*H)/v;
x=(V1b^2)/(2*g);

//===================================================
end Ex10_11_b;

//===================================================
end Ex10_11;
//===================================================
