//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.13 page-739
//Topic      : Flow Measurement and Control by Weirs
//Caption    : A rectangular channel encounters a dam

//===================================================
model Ex10_13
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//GIVEN: Fig E10.13b
//Parameter
parameter Real b(unit="m") = 8 "Width of channel";
parameter Real Q(unit="m^3/s") = 30 "VOlumetric flow rate";
parameter Real Y(unit="m") = 4 "Height of dam";
parameter Real So(unit="-") = 0.0004 "Slope of channel";
parameter Real n(unit="-") = 0.025 "Weir coefficient";
parameter Real alpha(unit="-") = 1 "Constant";

//Variable
Real H(unit="m") "Head of channel";
Real yo(unit="m") "Height at initial";
Real yc(unit="m") "Critical Height";
Real yn(unit="m",start=4) "Normal depth";

//Equation
equation

//USING: Eq. 10.56
(0.564+(0.0846*H/Y))*(b)*sqrt(g)*(H^1.5)=Q;
yo=(Y+H);

//USING: Eq. 10.30
yc=((Q*Q)/(b*b*g))^0.3333;

//USING: Chey Equation Eq. 10.19
Q=(alpha/n)*(b)*(yn)*((8*yn/(8+(2*yn)))^(0.6666))*(sqrt(So));

//===================================================
end Ex10_13;
//===================================================

//Remarks

//Final answer is obtained (Runge-Kutta method) through solving by integration

//Hence, it's half way done and final answer is not obtained
