//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.4 page-714
//Topic      : Efficient Uniform-Flow Channel
//Caption    : What are the best dimensions  y and b

//===================================================
package Ex10_4

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex10_4_a

//Parameter
parameter Real Q(unit="m^3/s") = 5  "Volumetric flow rate";
parameter Real So(unit="-") = 0.001 "Channel slope";
parameter Real n(unit="-") = 0.015  "Roughness factor";

//DATA:
parameter Real beta(unit="-") = 0.577 "Roughness factor";

//===================================================

//Variable

Real y(unit="m")    "Rectangular-normal depth";
Real A(unit="m^2")  "Rectangular channel area";
Real b(unit="m")    "Width of the channel";

//===================================================

//Equation

equation

//USING: Eq. 10.26 and Eq. 10.19
Q=(1/n)*(2*y*y)*((0.5*y)^(2/3))*(So^0.5);
A=(2*y*y);
b=(A/y);

end Ex10_4_a;
//===================================================

model Ex10_4_b
extends Ex10_4_a;

//Variable
Real yHH(unit="m")      "Half Hexagonal-normal depth";
Real Rh(unit="m")       "Half Hexagonal-Hydraulic height";
Real QH(unit="m^3/s")   "Half Hexagonal channel-Flow rate";

Real D(unit="m")        "Diameter of semi-circle";
Real P(unit="m")        "Wetted perimeter of semi-circle";
Real Rhs(unit="m")      "Semi_circle-Hydraulic height";
Real QS(unit="m^3/s")   "Semicircle channel-Flow rate";

//Equation
equation

//For the half-hexagon
//USING: Eq. 10.25
A=(yHH^2)*((2*((1+beta^2)^0.5))-beta);
Rh=(0.5*yHH);
QH=(1/n)*(A)*(Rh^(2/3))*(So^0.5);

//For the semi-circle
A=(pi*D*D)/8;
P=(0.5*pi*D);
Rhs=(A/P);
QS=(1/n)*(A)*(Rhs^(2/3))*(So^0.5);

end Ex10_4_b;
//===================================================
end Ex10_4;
//===================================================
