//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.7 page-719
//Topic      : Specific Energy; Critical Depth
//Caption    : Water flow in a wide channel

//===================================================
package Ex10_7
extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex10_7_a

//Parameter 
//GIVEN: Fig E10.7

parameter Real h(unit="cm") = 10    "Bump height";
parameter Real V1(unit="m/s") = 1.5 "Velocity of water";
parameter Real y1(unit="m") = 1     "Depth";

//===================================================

//Variable

Real Fr1(unit="-")  "Froude number";
Real E1(unit="m")   "Specific energy level-point1";
Real E2(unit="m")   "Specific energy level-point2";
Real y2(unit="m")   "Critical depth-point2";

//===================================================

//Equation

equation

Fr1=V1/((g*y1)^0.5); //Result shows subcritical
E1=(V1*V1/(2*g))+y1;
E2=(E1-(h/100));

//USING: Eq 10.39
((y2*y2*y2)-(E2*y2*y2)+(V1*V1*y1*y1/(2*g)))=0;

//===================================================
end Ex10_7_a;
//===================================================
model Ex10_7_b
extends Ex10_7_a;

//===================================================

//Variable

Real V2(unit="m/s") "Crest Velocity";
Real Fr2(unit="-")  "Froud number at crest";
Real Ec(unit="m")   "Critical energy level";
Real h_max(unit="m") "Maximum height";

//===================================================

//Equation

equation

V2=(V1*y1/y2);
Fr2=(V2)/((g*y2)^0.5);

//USING: Eq 10.31
Ec=(3/2)*((V1*V1/g)^(1/3));
h_max=E1-Ec;

//===================================================
end Ex10_7_b;
//===================================================
end Ex10_7;
//===================================================
