//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.2 page-771
//Topic      : Pump performance Curves and Similarity Rules
//Caption    : The pump is to pump water from a reservoir

//===================================================
package Ex11_2

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex11_2_a

//GIVEN: Fig. 11.7a
//Parameter
parameter Real r(unit="r/min") = 1170       "Pumping rate";
parameter Real Q(unit="gal/min") = 24000    "Flow rate of water";
parameter Real pa(unit="lbf/in^2") = 14.7   "Abs. surface pressure";
parameter Real hf(unit="ft") = 6            "Head loss";
parameter Real pv1(unit="lbf/in^2") = 0.26  "Vapour pressure at 60deg.F";
parameter Real pv2(unit="lbf/in^2") = 11.52 "Vapour prssure at 200deg.F";
parameter Real SG1(unit="-") = 1        "Specific gravity at 60deg.F";
parameter Real SG2(unit="-") = 0.9635   "Specific gravity at 200deg.F";
parameter Real rho(unit="slugs/ft^3") = 1.94 "Density of water";

//DATA: Fig. 11.7a at given flow rate
parameter Real NPSH(unit="ft") = 40     "Net Positive Suction Head";

//Variable
Real Zi(unit="ft") "Height";

//Equation
equation
//USING: Eq. 11.20
NPSH=(((pa-pv1)*(1/(0.0833*0.0833)))/(rho*g*SG1))-Zi-hf;

end Ex11_2_a;

//===================================================

model Ex11_2_b
extends Ex11_2_a;

//Variable
Real Zbi(unit="ft") "Height at 200deg.F";

//Equation
equation
//USING: Eq. 11.20
NPSH=(((pa-pv2)*1/(0.0833*0.0833))/(rho*g*SG2))-(Zbi)-hf;

end Ex11_2_b;

//===================================================
end Ex11_2;
//===================================================
