//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.4 page-775
//Topic      : Pump Performance Curves and Similarity Rules
//Caption    : To build a pump which delivers water

//===================================================
package Ex11_4

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex11_4_a

//GIVEN: Fig. 11.8
//Parameter
parameter Real Q(unit="gal/min") = 3000 "Flow rate";
parameter Real n(unit="r/min") = 1200   "Rotation";

//DATA: Fig. 11.8 or Eqs. 11.27
parameter Real CQ(unit="-") = 0.115     "Capacity coefficient";
parameter Real CQ_max(unit="-") = 0.23  "Maximum capacity coefficient";
parameter Real CH(unit="-") = 6         "Shutoff head coefficient";
parameter Real CHS(unit="-") = 0.37     "Suction head coefficient";

//Variable
Real D(unit="in") "Diameter of impeller";

//Equation
equation
(Q*0.00223)=(CQ*(n/60)*(D^3))*(0.0833^3); //CONVERSION: ft to in
//CONVERSION: gal/min to ft^3/s
//CONVERSION: r/min to r/s

end Ex11_4_a;

//===================================================

model Ex11_4_b
extends Ex11_4_a;

//Variable
Real Q_max(unit="gal/min") "Maximum flow rate";

//Equation
equation
Q_max=Q*CQ_max/CQ;

end Ex11_4_b; 

//===================================================

model Ex11_4_c
extends Ex11_4_b;
extends Ex11_4_a;

//Variable
Real H(unit="ft") "Shutoff head";

//Equation
equation
H=(CH*((n/60)^2)*((D*0.0833)^2))/g;

end Ex11_4_c;

//===================================================

model Ex11_4_d
extends Ex11_4_a;
extends Ex11_4_b;
extends Ex11_4_c;

//Variable
Real NPSH(unit="ft") "Net Positive Suction Head";

//Equation
equation
NPSH=(CHS*((n/60)^2)*((D*0.0833)^2))/g;

end Ex11_4_d; 
//===================================================
end Ex11_4;
//===================================================
