//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.8 page-792
//Topic      : Matching Pumps to System Characteristics
//Caption    : Elevation change greater than single pump

//===================================================
model Ex11_8

//EXTENDING: Example 11.6
//Parameter 
parameter Real D(unit="in") = 32        "Diameter of impeller";
parameter Real n(unit="r/min") = 1170   "Revolution";
parameter Real L(unit="ft") = 1500      "Length of pipe";
parameter Real D_pipe(unit="in") = 16   "Diameter of pipe";
parameter Real f(unit="-") = 0.030      "Friction factor pipe";
parameter Real z1(unit="ft") = 500      "Height of point-1";
parameter Real z2(unit="ft") = 0        "Height of point-2";

//===================================================
//Variable

Real Q(unit="gal/min") "Volumetric flow rate";

//===================================================
//Equation

equation

//Total head becomes twice
(Q^2)=((980-z1)/(1.335+0.52))*(10^6);

//===================================================
end Ex11_8;
//===================================================
