//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.13 page-98
//Topic     : Pressure Distribution in Rigid-Body Motion
//Caption   : A drag racer rests her coffee mug on a horizontal tray 

//===================================================
model Ex2_13

extends Modelica.Math;

model Ex2_13_a
//Parameter
parameter Real ax(unit="m/s^2") = 7 "Rigid-body horizontal acceleration";
parameter Real rho(unit="kg/m^3") = 1010    "Density of coffee";
parameter Real g(unit="m/s^2") = 9.81       "Gravity acceleration";
parameter Real dep(unit="cm") = 10          "Mug-depth";
parameter Real dia(unit="cm") = 6           "Mug-Diamater";
parameter Real d(unit="cm") = 3             "Distance from centroid";
parameter Real deep(unit="cm") = 7          "Coffee in the mug";


//Variable
Real angle(unit="deg.") "Angle if tilt";
Real del_z(unit="cm") "Rise of free surface at rear side";



//Equation
equation
(angle) = (atan((ax/g)))*(180/3.14);
del_z= (d*tan(angle*(3.14/180)));

end Ex2_13_a;
//===================================================

model Ex2_13_b
extends Ex2_13_a;

//Variable
Real pA1(unit="Pa") "Pressure at A when at rest";
Real pA2(unit="Pa") "Pressure at A when at accelerating";
Real pA3(unit="Pa") "Pressure at A increased by 31%" ;

//Equation
equation

pA1=(rho*g*(deep/100)); //pA1=(rho*g*h(rest))

pA2=((rho)*(((g^2)+((deep/100)^2))^(0.5)))*((deep/100)+((del_z/100)))*cos(angle*3.14/180) ;

pA3 =((rho*g)*(((del_z)/100)+((deep)/100)));

end Ex2_13_b;

//===================================================
end Ex2_13;
//===================================================

//Remarks
//For pressure when accelerating


//Book answer is wrong:
//Inconsistency in the unit ---> cm to m conversion of parameter 'deep'
//Parameter     Textbook Value      Obtained Value
//pA2(Pa)       906                 737.28
