//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.16 page-177
//Topic     : Frictionless Flow: The Bernoulli Equation
//Caption   : A fire hose with a nozzle discharge.

//===================================================
model Ex3_16

//Parameter
parameter Real D1(unit="cm") = 10       "Length of hose";
parameter Real D2(unit="cm") = 3        "Nozzle discharge diameter";
parameter Real Q(unit="m^3/min") = 1.5  "Volumetric flow rate";
parameter Real rho(unit="kg/m^3") = 1000 "Density of water";

//Variable
Real V2(unit="m/s") "Velocity-outlet";
Real V1(unit="m/s") "Velocity-inlet";
Real p1(unit="Pa gage") "Pressure-inlet";
Real m(unit="kg/s") "mass flow rate";
Real A1(unit="m^2") "Area-section-1";
Real FB(unit="N")   "Force-flange bolts";

//equation
equation
V2=((Q/60)/((3.14/4)*((D2/100)^2)));
V1=((Q/60)/((3.14/4)*((D1/100)^2)));
p1=((0.5*rho)*((V2^2)-(V1^2)));
m=(rho*(Q/60));
A1=((3.14/4)*((D1/100)^2));
FB=((p1*A1)-((V2-V1)*(m)));

//===================================================
end Ex3_16;
//===================================================
