//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.17 page-180
//Topic     : The Angular Momentum Theorem
//Caption   : Supported pipe bend.

//===================================================
model Ex3_17

//Parameter
parameter Real D1(unit="in") = 3 "Diamter-inlet";
parameter Real D2(unit="in") = 3 "Diamter-outlet";
parameter Real p1(unit="lbf/in^2") = 100 "Pressure-inlet";
parameter Real p2(unit="lbf/in^2") = 80 "Pressure-outlet";
parameter Real V1(unit="ft/s") = 40 "Velocity-inlet";
parameter Real rho(unit="slugs/ft^3") = 1.94 "Density of fluid";
parameter Real h1(unit="in") = 2 "Height-1"; //Given in diagram
parameter Real h2(unit="in") = 10 "Height-2"; //Given in diagram

//Variable
Real m(unit="slugs/s") "Mass flow rate";
Real TA(unit="ft.lbf") "Torque";
Real A1(unit="ft^2") "Area-inlet";
Real P1(unit="lbf/ft^2") "Pressure-inlet"; //Unit conversion lbf/in^2 to lbf/ft^2
Real P2(unit="lbf/ft^2") "Pressure-outlet"; //Unit conversion lbf/in^2 to lbf/ft^2

//Equation
equation
P1=(p1/(0.0833^2)); //Unit conversion lbf/in^2 to lbf/ft^2
P2=(p2/(0.0833^2)); //Unit conversion lbf/in^2 to lbf/ft^2

A1=((3.14/4)*((3*0.0833)^2)); //Converting in to ft //A1=A2
m=(rho*A1*V1); //V1=V2

TA=(((h2*0.0833)*((P2*A1)+(m*V1)))-((h1*0.0833)*((P1*A1)+(m*V1))))
;

//===================================================
end Ex3_17;
//===================================================
