//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.21 page-189
//Topic     : The Energy Equation
//Caption   : Gasoline is pumped through smooth pipe.

//===================================================
model Ex3_21
extends Modelica.Math;

//Parameter
parameter Real D(unit="cm") = 12 "Diameter of pipe";
parameter Real l(unit="km") = 10 "Length of pipe";
parameter Real Q(unit="m^3/hr") = 75 "Flow rate";
parameter Real p_in(unit="atm") = 24 "abs.Inlet pressure";
parameter Real p_out(unit="N/m^2") = 101350 "Standard atmospheric pressure";
parameter Real z2(unit="m") = 150 "Height of exit point";

//Property values from TABLE A.3 for Gasoline at 20deg.C
parameter Real rhog(unit="kg/m^3") = 680 "Density of gasoline";


final constant Real g=9.81 "Gravity-acceleration";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Variable
Real alpha(unit="N/m^3") "Specific weight of Gasoline";
Real Vin(unit="m/s") "Average velocity-inlet";
Real Vout(unit="m/s") "Average velocity-outlet";
Real V_head(unit="m") "Velocity head";
Real hf(unit="m") "Frictional head loss";
Real r(unit="-") "Ratio (frictional head/velocity head)";

//Equation
equation
alpha=(rhog*g);
Vin=((Q/3600)/((pi/4)*((D/100)^2))); //Converting hr to s
Vout=Vin; //Pipe diameter constant = Average velocity is same
V_head=(Vin^2)/(2*g);
(hf+((p_out/alpha))+z2)=((p_in*101350)/alpha); // Converting atm to N/m^2
r=(hf/(V_head)); //Ratio of (frictional head/velocity head)

//===================================================
end Ex3_21;
//===================================================
