//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.23 page-192
//Topic     : the Energy Equation 
//Caption   : A hydroelectric power plant.

//===================================================
model Ex3_23
extends Modelica.Math;

//Parameter
parameter Real Q(unit="m^3/s") = 30 "Volumetric flow rate of water";
parameter Real V2(unit="m/s") = 2 "Velocity-discharge";
parameter Real hf(unit="m") = 20 "Head loss";
parameter Real alpha(unit="-") = 1.06 "Kinetic energy correction factor";
parameter Real z1(unit="m") = 100 "Distance-section1";
parameter Real rho(unit="kg/m^3") = 998 "Density-water";

final constant Real g(unit="m/s^2") = 9.81 "Gravitational-acceleration";

//Given (From figure E3.23): V1=0, p1=p_atm, Z1=100m

//===================================================

//variable
Real ht(unit="m") "Turbine head";
Real P(unit="MW") "Total power extracted";

//===================================================

//Equation
equation
z1=(((alpha*((V2)^2))/(2*g))+(hf)+(ht));
P=((rho*Q)*(g*ht))/(10^6);

//===================================================
end Ex3_23;
//===================================================
