//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.6 page-157
//Topic     : The Linear Momentum Equation 
//Caption   : A control colume of nozzle section.

//===================================================
model Ex3_6

//Parameter
parameter Real ps(unit="lbf/in^2") = 40 "Surface pressure-absolute at section-1";
parameter Real pa(unit="lbf/in^2") = 15 "Atmospheric pressure-absolute at section-2";
parameter Real D1(unit="in") = 3 "Inlet diameter";
parameter Real D2(unit="in") = 1 "Outlet diameter";

//Variable
Real F_press(unit="lbf") "Pressure force";

//Equation
equation
F_press=(ps-pa)*(3.14/4)*((D1)^2); //This answer multipiled by 'i' component //Given in textbook.

//===================================================
end Ex3_6;
//===================================================
