//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 4 : Differential Relations for Fluid Flow
//Example   : 4.11 page-273
//Topic     : Fully devoloped Laminar flow
//Captions  : Oil through a horizontal pipe

//==========================================================

package Ex4_11

//================================================
model Ex4_11_a
extends Modelica.Constants;

//============================
//parameter section
parameter Real Q(unit="m^3/h")=1.1  "Flow rate of oil";
parameter Real d(unit="cm")=2       "Diameter of the pipe";
parameter Real L(unit="m")=12       "Length of the pipe";
parameter Real rho(unit="kg/m^3")=870"Density of oil";
parameter Real Mu(unit="kg/ms")=0.104"Viscosity of the oil";

//============================
//Variable section

Real R(unit="m")        "Radius of the pipe";
Real Vavg(unit="m/s")   "Average velocity";

//============================
//Equation section

equation

R=(d*1e-2)/2;
Vavg=(Q/3600)/(pi*(R^2));

end Ex4_11_a;

//================================================
model Ex4_11_b
extends Ex4_11_a;

//============================
//Variable section

Real Red(unit="-")"Reynolds number";

//============================
//Equation section

equation
 
Red=(rho*Vavg*(d/100))/Mu;
 
end Ex4_11_b;


//================================================
model Ex4_11_c
extends Ex4_11_a;

//============================
//Variable section

Real delP(unit="Pa")"Pressure drop in the pipe";
//============================
//Equation section

equation

delP=(8*Mu*L*Q)/(pi*3600*(R^4));

end Ex4_11_c;
//================================================
model Ex4_11_d
extends Ex4_11_a;
extends Ex4_11_b;
extends Ex4_11_c;

//============================
//Variable section

Real P(unit="W")"Power required";

//============================
//Equation section

equation

P=(Q*delP)/3600;

end Ex4_11_d;
//==========================================================
end Ex4_11;
