//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 5 : Dimensional Analysis and Similarity
//Example   : 5.7 page-319
//Topic     : Nondimensionalization of the Basic Equations
//Caption   : A smooth cylinder is tested in a wind tunnel.

//===================================================
package Ex5_7

model Ex5_7_a

//Parameter
parameter Real d(unit="cm") = 1 "Diameter-cylinder";
parameter Real d_chim(unit="m") = 1 "Diameter-chimney";
parameter Real L_chim(unit="m") = 20 "Length-chimney";
parameter Real L(unit="cm") = 20 "Length-cylinder";
parameter Real U(unit="m/s") = 45 "Velocity of air at 20deg.C";
parameter Real F(unit="N") = 2.2 "Drag force";
parameter Real Umin(unit="m/s") = 0.15 "Velocity-minimum";
parameter Real Umax(unit="m/s") = 1.5 "Velocity-maximum";

//Figure 5.3 (a) for reference
//Given: data of air at 20deg.C
parameter Real rho(unit="kg/m^3") = 1.2 "Density-air";
parameter Real mew(unit="kg/m.s") = 0.000018 "Viscosity-air";
parameter Real len_dia(unit="-") = 20 "Length to diameter ratio";
parameter Real CD(unit="-") = 0.91 "Drag coefficient";

//===================================================

//Variable
Real Red(unit="-") "Reynolds number";
Real CD_test(unit="-") "Test drag coefficient";

//===================================================

//Equation

equation

Red=(rho*U*(d/100))/(mew);
//Reynolds number is in the range of 10^4 < Rey < 10^5

CD_test=(F)/(0.5*(rho)*(U*U)*(L/100)*(d/100));

//===================================================
end Ex5_7_a;
//===================================================

model Ex5_7_b
extends Ex5_7_a;

//Variable 
//Figure 5.3 (a)
//Chimney has (L/d = 20)
Real Fmin(unit="N") "Drag force-minimum";
Real Fmax(unit="N") "Drag force-maximum";

//===================================================

//Equation

equation

Fmin=(CD*(rho/2)*(Umin*Umin)*(L_chim)*(d_chim));
Fmax=(CD*(rho/2)*(Umax*Umax)*(L_chim)*(d_chim));

//===================================================
end Ex5_7_b;
//===================================================
end Ex5_7;
//===================================================
