//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 5 : Dimensional Analysis and Similarity
//Example   : 5.9 page-327
//Topic     : Modelling and its Pitfalls
//Caption   : A prototype airplane.

//===================================================
package Ex5_9

model Ex5_9_a

//===================================================

//Parameter

parameter Real C(unit="m") = 1.6 "Chord length";
parameter Real Ma(unit="-") = 2 "Mach number-air";
parameter Real T(unit="deg.C") = 100 "Temperature-helium wind tunnel";
parameter Real p(unit="atm") = 1 "Pressure-helium wind tunnel";

//Given: Matching both Reynolds number and Mach number by increasing density 
parameter Real VHe_2(unit="m/s") = 2268 "Velocity-Helium";

//Given: TABLE A.4 (Properties of helium)
parameter Real R(unit="m^2/s^2.K") = 2077 "Gas constant";
parameter Real k(unit="-") = 1.66 "Constant";
parameter Real mew_He(unit="kg/m.s") = 0.0000232 "Viscosity-Helium";


//Given: TABLE A.6 (at an altitude of 10000m)
parameter Real rho_air(unit="kg/m^3") = 0.4125 "Density-air";
parameter Real a_air(unit="m/s") = 299.5 "Speed-air";
parameter Real mew_air(unit="kg/m.s") = 0.0000148 "Viscosity-air";
parameter Real n(unit="-") = 0.7 "Power number";

//===================================================

//Variable

Real aHe(unit="m/s") "Helium speed";
Real VHe(unit="m/s") "Velocity Helium";
Real Rey_air(unit="-") "Reynolds number-air";
Real Rey_He(unit="-") "Reynolds number-Helium";
Real Vair(unit="-") "Velocity-air";
Real rho_He(unit="kg/m^3") "Density-Helium";
Real C_model(unit="m") "Chord length-model";

//===================================================

//Equation

equation

C_model=C/8;
aHe=((k*R*(T+273))^0.5); //Given Mach number (Air = Helium)
Ma=(VHe/aHe);
Vair=(Ma*a_air);
rho_He=(101350)/(R*(T+273));
Rey_air=(rho_air*(Vair)*(C))/(mew_air);
Rey_He=(rho_He*(VHe)*(C_model))/(mew_He);

//===================================================
end Ex5_9_a;
//===================================================

model Ex5_9_b
extends Ex5_9_a;

//===================================================

//Variable
Real VHe_1(unit="m/s") "Velocity-Helium";

//===================================================

//Equation

equation

//Given: Reynolds number (model = prototype)
(rho_He*VHe_1*(C_model))=(mew_He*Rey_air);

//===================================================
end Ex5_9_b;
//===================================================

model Ex5_9_c
extends Ex5_9_a;
extends Ex5_9_b;

//===================================================

//Variable

//Given: Matching both Reynolds number and Mach number by increasing density 
Real rho_He_2(unit="kg/m^3") "Density-Helium";
Real p_He(unit="Pa") "Pressure-Helium";

//===================================================

//Equation

equation
(rho_He_2*(VHe_2)*(C_model))=(Rey_air*mew_He);
p_He=(rho_He_2*(R)*(T+273));

//===================================================
end Ex5_9_c;
//===================================================
end Ex5_9;
//===================================================
