//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.11 page-378
//Topic     : Four Types of Pipe Flow Problems
//Caption   : Moody problem to find wall roughness

//===================================================
model Ex6_11
extends Modelica.Math;

//Parameter 
//Given: Fig. 6.7
parameter Real d(unit="ft") = 0.5 "Diameter-iron pipe";
parameter Real L(unit="ft") = 200 "Length-iron pipe";
parameter Real V(unit="ft/s") = 6 "Mean velocity-water";

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Data: Table A.3 for water
parameter Real rho(unit="slug/ft^3") = 1.94         "Density-water";
parameter Real mew(unit="slug/ft.s") = 0.0000209    "Density-water";

parameter Real hf(unit="ft") = 4.5 "Head loss";

//===================================================

//Variable

Real rey(unit="-")      "Reynolds number";
Real f(unit="-")        "Friction factor";
Real Q(unit="ft^3/s")   "Flow rate";
Real ratio(unit="-")    "Ratio: e/d";
Real e(unit="ft")       "Roughness height";

//===================================================

//Equation

equation

Q=(V*pi*((d/2)^2));
rey=(rho*V*d)/(mew);
f=(hf)/((L/d)*((V^2)/(2*g)));
(f^(-0.5))=((-2)*log10((ratio/3.7)+(2.51/(rey*(f^0.5)))));
e=(ratio*d);

//===================================================
end Ex6_11;
//===================================================
