//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.15 page-388
//Topic     : Flow in Noncircular Ducts
//Caption   : Air forced through a horizontal square duct

//===================================================
model Ex6_15
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real rho(unit="slug/ft^3") = 0.00237  "Density-air";
parameter Real v(unit="ft^2/s") = 0.000157      "Kinematic viscosity-air";
parameter Real L(unit="ft") = 100               "Length-square";
parameter Real Q(unit="ft^3/s") = 25            "Flow rate-air";
parameter Real e(unit="ft") = 0.0003            "Roughness height";
parameter Real a(unit="in") = 9                 "Side of square";

//DATA: Moody chart 
parameter Real f(unit="-") = 0.0177 "Friction factor";

//===================================================

//Variable

Real V(unit="ft/s")         "Mean velocity";
Real Dh(unit="ft")          "Hydraulic diameter";
Real D_eff(unit="ft")       "Effective hydraulic diameter";
Real rey_eff(unit="-")      "Reynolds number";
Real ratio(unit="-")        "Ratio: e/D_eff";
Real del_p(unit="lbf/ft^2") "Pressure drop";

//===================================================

//Equation

equation

V=Q/((a*0.0833)^2);
Dh=4*((a*0.0833)^2)/(4*a*0.0833);
D_eff=(64/56.91)*(Dh); //DATA: Table 6.4 for (b/a = 1)
rey_eff=(V*D_eff)/v;
ratio=(e/D_eff);
del_p=(rho*g)*((f*L*V*V)/(Dh*2*g));

//===================================================
end Ex6_15;
//===================================================
