//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.17 page-399
//Topic     : Multiple-Pipe Systems
//Caption   : Three pipe series system

//===================================================
model Ex6_17
extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real p_d(unit="Pa") = 150000      "Total pressure drop";
parameter Real z_d(unit="m") = 5            "Elevation drop";
parameter Real rho(unit="kg/m^3") = 1000    "Density-Water";
parameter Real v(unit="m^2/s") = 0.00000102 "Kinematic viscosity-water";

//GIVEN: Fig. 6.24a
//DATA: Given
parameter Real L1(unit="m") = 100 "Length-pipe1";
parameter Real L2(unit="m") = 150 "Length-pipe2";
parameter Real L3(unit="m") = 80 "Length-pipe3";

parameter Real d1(unit="cm") = 8 "Diameter-pipe1";
parameter Real d2(unit="cm") = 6 "Diameter-pipe2";
parameter Real d3(unit="cm") = 4 "Diameter-pipe3";

parameter Real e1(unit="mm") = 0.24 "Roughness-pipe1";
parameter Real e2(unit="mm") = 0.12 "Roughness-pipe2";
parameter Real e3(unit="mm") = 0.20 "Roughness-pipe3";

//DATA: Moody chart
parameter Real f1(unit="-") = 0.0262 "Friction factor-pipe1";
parameter Real f2(unit="-") = 0.0234 "Friction factor-pipe2";
parameter Real f3(unit="-") = 0.0304 "Friction factor-pipe3";


//===================================================

//Variable

Real del_h(unit="m") "Total head loss";
Real V1(unit="m/s") "Velocity-water-pipe1";
Real V2(unit="m/s") "Velocity-water-pipe2";
Real V3(unit="m/s") "Velocity-water-pipe3";
Real rey1(unit="-") "Reynolds number-pipe1";
Real rey2(unit="-") "Reynolds number-pipe2";
Real rey3(unit="-") "Reynolds number-pipe3";
Real Q(unit="m^3/h") "Volumetric flow rate";

//===================================================

//Equation

equation

del_h=(p_d/(rho*g))+(z_d);
del_h=((V1^2)/(2*g))*((f1*L1/(d1/100))+(((f2*L2)/(d2/100))*((d1/d2)^4))+(((f3*L3)/(d3/100))*((d1/d3)^4)));
V2=((d1/d2)^2)*V1;
V3=((d1/d3)^2)*V1;
rey1=(V1*(d1/100))/(v);
rey2=(d2/d1)*(V2/V1)*rey1;
rey3=2*rey1;
Q=(pi/4)*((d1/100)^2)*V1*3600;

//===================================================
end Ex6_17;
//===================================================

//REMARKS:

//Parameter     Obtained value      Textbook value

//  Q(m^3/h)    10.4644             10.2
//===================================================
