//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.7 page-372
//Topic     : Turbulent Pipe Flow
//Caption   : Oil flows through cast iron pipe

//===================================================
package Ex6_7

model Ex6_7_a
extends Modelica.Math;

//Parameter
parameter Real rho(unit="kg/m^3") = 900     "Density-oil";
parameter Real v(unit="m^2/s") = 0.00001    "Kinematic viscosity-oil";
parameter Real Q(unit="m^3/s") = 0.2        "Volumetric flow rate-oil";
parameter Real d(unit="mm") = 200           "Diameter cast iron pipe";
parameter Real L(unit="m") = 500            "Length cast iron pipe";
parameter Real angle(unit="deg.C") = 10     "Slope angle";

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";

//Given: Table. 6.1
parameter Real e(unit="mm") = 0.26 "Roughness height";

//Data: Moody chart
parameter Real f(unit="-") = 0.0225 "Friction factor";

//===================================================

//Variable

Real V(unit="m/s")      "Velocity";
Real rey(unit="-")      "Reynolds number";
Real ratio(unit="-")    "Ratio: e/d";
Real hf(unit="m")       "Head loss";

//===================================================

//Equation

equation
V=(Q)/(pi*(((d/1000)/2)^2));
rey=(V*(d/1000))/v;
ratio=(e/d);
hf=(f*L*(V^2))/((d/1000)*2*g);

//===================================================
end Ex6_7_a;
//===================================================

model Ex6_7_b
extends Ex6_7_a;

//===================================================

//Variable

Real del_p(unit="Pa") "Pressure drop";

//===================================================

//Equation

equation

del_p=(rho*g)*(hf-(L*(sin(angle*(pi/180)))));

//===================================================
end Ex6_7_b;

//===================================================
end Ex6_7;
//===================================================

//Variation in answer

//Textbook answer differs due to approximated values

//Variable      Obtained    Textbook_Value
// del_p        259307      265000
