//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.9 page-374
//Topic     : Four Types of Pipe Flow Problems
//Caption   : Oil flows through a 30cm diameter pipe

//===================================================

model Ex6_9
extends Modelica.Math;

//Parameter

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant Real g(unit="m^2/s") = 9.81 "Standard acceleration of gravity on earth";

parameter Real rho(unit="kg/m^3") = 950 "Density-oil";
parameter Real v(unit="m^2/s") = 0.00002 "Kinematic viscosity-oil";
parameter Real d(unit="cm") = 30 "Diameter-pipe";
parameter Real L(unit="m") = 100 "Length of pipe";
parameter Real hf(unit="m") = 8 "Head loss";
parameter Real r_rough(unit="-") = 0.0002 "Roughness ratio";

//===================================================

//Variable

Real dp(unit="-")   "Dimensionless head loss parameter";
Real rey(unit="-")  "Reynolds number";
Real V(unit="m/s")  "Velocity";
Real Q(unit="m^3/s") "Volumetric flow rate";

//===================================================

//Equation

equation

dp=(g*((d/100)^3)*(hf))/(L*(v^2));
rey=((8*dp)^(0.5))*(-1)*(log10((r_rough/3.7)+(1.775/(dp^(0.5)))));
V=(v*rey)/(d/100);
Q=(V*pi/4)*((d/100)^2);

//===================================================
end Ex6_9;
//===================================================
