//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 8 : Potential Flow and Computational Fluid Dynamics
//Example   : 8.2 page-541
//Topic     : Superposition of Plane Flow Solutions
//Caption   : An offshore powerplant.

//===================================================
package Ex8_2

extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex8_2_a

//Parameter
parameter Real Q(unit="ft^3/s") = 1500  "Flow rate of water";
parameter Real b(unit="ft") = 30        "Depth";

//GIVEN: Fig. E8.2
parameter Real U(unit="ft/s") = 0.7     "Tidal velocity";

//===================================================

//Variable

Real m(unit="ft^2/s")   "Sink strength";
Real a(unit="ft")       "Intake effect length";

//===================================================

//Equation

equation

m=Q/(2*pi*b);
a=(m/U);

//===================================================
end Ex8_2_a;
//===================================================

model Ex8_2_b
extends Ex8_2_a;

//===================================================

//Variable

Real L(unit="ft") "Width of tidal flow";

//===================================================

//Equation

equation

L=(2*pi*a);

//===================================================
end Ex8_2_b;
//===================================================
end Ex8_2;
//===================================================
