//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.14 page-656
//Topic     : Frictionless Duct Flow with Heat Transfer
//Caption   : A fuel air mixture enters a duct of combustion chamber

//===================================================
package Ex9_14
extends Modelica.Math;

model Ex9_14_a

//Parameter
parameter Real k(unit="-") = 1.4    "Constant";
parameter Real V1(unit="m/s") = 75  "Air velocity";
parameter Real p1(unit="kPa") = 150 "Inlet pressure";
parameter Real T1(unit="K") = 300   "Inlet temperature";
parameter Real q(unit="kJ/kg") = 900 "Heat addition";
parameter Real R(unit="m^2/s^2.K") = 287 "Air rate constant";

//DATA: for air
parameter Real cp(unit="J/kg.K") = 1005 "Specific heat of air";

//DATA: Table B.4
parameter Real Ma2(unit="-") = 0.573 "Outlet Mach number";

//Variable
Real T01(unit="K")      "Inlet stagnation temperature";
Real T02(unit="K")      "Outlet stagnation temperature";
Real a1(unit="m/s")     "Sound speed";
Real Ma1(unit="-")      "Initial Mach number";
Real T0star(unit="K")   "Sonic temperature";
Real ratio(unit="-")    "Stagnation temperature ratio";

//For exit properties
//Finding for outlet from inlet properties
Real V2(unit="m/s") "Outlet velocity";
Real p2(unit="kPa") "Outlet pressure";
Real T2(unit="K")   "Outlet temperature";


//For Mach number Ma1=0.216
Real V1_ratio(unit="-") "Velocity ratio Inlet";
Real p1_ratio(unit="-") "Pressure ratio Inlet";
Real T1_ratio(unit="-") "Temperature ratio Inlet";

//For Mach number Ma1=0.573
Real V2_ratio(unit="-") "Velocity ratio Outlet";
Real p2_ratio(unit="-") "Pressure ratio Outlet";
Real T2_ratio(unit="-") "Temperature ratio Outlet";


//Equation
equation
T01=T1+((V1*V1)/(2*cp));
T02=(T01)+(q*1000/cp); 
a1=sqrt(k*R*T1);
Ma1=(V1/a1);
ratio=(T02/T0star);

//USING: Eq. 9.78a
(T01/T0star)*(1+k*Ma1*Ma1)^2=(k+1)*Ma1*Ma1*(2+(k-1)*Ma1*Ma1);

//USING: Eq. 9.78
//For Ma1
V1_ratio=(k+1)*Ma1*Ma1/(1+k*Ma1*Ma1);
p1_ratio=(k+1)/(1+k*Ma1*Ma1);
T1_ratio=(((k+1)^2)*Ma1*Ma1)/(1+k*Ma1*Ma1)^2;

//For Ma2
V2_ratio=(k+1)*Ma2*Ma2/(1+k*Ma2*Ma2);
p2_ratio=(k+1)/(1+k*Ma2*Ma2);
T2_ratio=(((k+1)^2)*Ma2*Ma2)/(1+k*Ma2*Ma2)^2;

V2=V1*(V2_ratio/V1_ratio);
p2=p1*(p2_ratio/p1_ratio);
T2=T1*(T2_ratio/T1_ratio);

end Ex9_14_a;
//===================================================

model Ex9_14_b
extends Ex9_14_a;

//Variable Ex9_14_b
Real qmax(unit="J/kg") "Maximum allowable heat";

//Equation Ex9_14_b
equation
qmax=cp*(T0star-T01);

end Ex9_14_b;
//=================================================== 
end Ex9_14;
//===================================================
