//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.19 page-675
//Topic     : Prandtl-Meyer Expansion Waves
//Caption   : A flat plate airfoil is immersed in a stream 

//===================================================
package Ex9_19
extends Modelica.Math;

model Ex9_19_a
extends Ex9_19_c;
extends Ex9_19_d;

//GIVEN: Fig. E9.19


//Variable
Real CL(unit="-") "Lift Coefficient";

Real CLl(unit="-") "Low speed Coefficient";

//Equation
equation


//USING: Eq.102
CL=(L)/(0.5*k*p*Ma*Ma*A);
CLl=(2*3.14)*(sin(alpha*3.14/180));

end Ex9_19_a;

//===================================================

model Ex9_19_b
extends Ex9_19_a;
extends Ex9_19_c;
extends Ex9_19_d;

//Variable
Real CD(unit="-") "Drag Coefficient";

//Equation
equation
//USING: Eq. 9.102
CD=(D)/(0.5*k*p*Ma*Ma*A);

end Ex9_19_b;
//===================================================

model Ex9_19_c

//Parameter
parameter Real k(unit="-") = 1.4    "Constant";
parameter Real C(unit="m") = 2      "Chord length";
parameter Real alpha(unit="Deg.") = 8 "Immersed angle";
parameter Real Ma(unit="-") = 2.5   "Mach number";
parameter Real p(unit="kPa") = 100  "Air foil pressure";
parameter Real p2(unit="kPa") = 165.7 "Air foil pressure at point-2";
parameter Real p3(unit="kPa") = 56.85 "Air foil pressure at point-3";
parameter Real b(unit="m") = 1      "Span width";
parameter Real A(unit="m^2") = 2    "Wing area";

//Variable
Real L(unit="kN") "Lift Force ";
Real F(unit="kN") "Total Force ";

//Equation
equation
L=F*cos(alpha*(3.14/180));
F=(p2-p3)*b*C;

end Ex9_19_c;

//===================================================

model Ex9_19_d

extends Ex9_19_c;

//Variable
Real D(unit="kN") "Drag Force ";

//Equation
equation
D=F*sin(alpha*(3.14/180));

end Ex9_19_d;
//===================================================
end Ex9_19;
//===================================================
