//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.20 page-677
//Topic     : Prandtl-Meyer Expansion Waves
//Caption   : Repeat parts of Example 19

//===================================================
model Ex9_20
extends Modelica.Math;

//Parameter 
parameter Real k(unit="-") = 1.4    "Constant";
parameter Real C(unit="m") = 2      "Chord length";
parameter Real alpha(unit="Deg.") = 8 "Immersed angle";
parameter Real Ma(unit="-") = 2.5   "Mach number";
parameter Real p(unit="kPa") = 100  "Air foil pressure";
parameter Real p2(unit="kPa") = 165.7 "Air foil pressure at point-2";
parameter Real p3(unit="kPa") = 56.85 "Air foil pressure at point-3";
parameter Real b(unit="m") = 1      "Span width";
parameter Real A(unit="m^2") = 2    "Wing area";

//Variable
Real CL(unit="-") "Lift coefficient";
Real CD(unit="-") "Drag Coefficient";

//Equation
equation
//USING: Eqs.(9.104) and (9.105)
CL=(4*alpha*3.14/180)/sqrt(Ma*Ma-1);
CD=(4*(alpha*(3.14/180))^2)/sqrt(Ma*Ma-1);

//===================================================
end Ex9_20;
//===================================================
