//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.6 page-634
//Topic     : The Normal Shock Wave
//Caption   : Air flows from a reservoir through a throat

//===================================================
package Ex9_6

model Ex9_6_a

//Parameter
parameter Real p(unit="kPa") = 300  "Air pressure";
parameter Real T(unit="K") = 500    "Air temperature";

//GIVEN: Properties of Air
parameter Real R(unit="m^2/s^2.K") = 287    "Air rate constant";
parameter Real k(unit="-") = 1.40           "Constant";
parameter Real cp(unit="m^2/s^2.K") = 1005  "Air specific heat";

//Data given in the problem
parameter Real A1(unit="m^2") = 2   "Inlet area";
parameter Real A1f(unit="m^2") = 1  "Area of throat";
parameter Real A3(unit="m^2") = 3   "Area of section-3";
 
//DATA: Section-C from Table B.2
parameter Real Ma1c(unit="-") = 2.2             "Mach number for section-2";
parameter Real poc_ratio(unit="-") = 0.628      "Initial stagnation pressure section-2";
parameter Real Astar_ratio(unit="-") = 1.592    "Critical area ratio for section-2";


//Variable
Real ratio(unit="-")        "Ratio of area";
Real Ma1(unit="-",start=2)  "Mach number";
Real p1(unit="kPa")         "Pressure at section-1";

//Equation 
equation
//USING: Eq. 9.45
ratio=(A1/A1f);

(2*Ma1*1.728)=(1+0.2*Ma1*Ma1)^3;

p1=(p)/((1+(0.2*Ma1*Ma1))^3.5);

end Ex9_6_a;
//===================================================

model Ex9_6_b
extends Ex9_6_a;

//Variable Ex9_6_b
Real p2(unit="kPa") "Pressure at section-2";

//Equation Ex9_6_b
equation
p2 = (p1/(k+1))*((2*k*Ma1*Ma1)-(k-1));

end Ex9_6_b;
//===================================================

model Ex9_6_c
extends Ex9_6_a;
extends Ex9_6_b;

//Variable
Real po2(unit="kPa") "Stagnation pressure at section-2";

//Equation
equation
po2=(poc_ratio)*(p);

end Ex9_6_c;
//===================================================

model Ex9_6_d
extends Ex9_6_c;
extends Ex9_6_a;
extends Ex9_6_b;

//Variable 
Real A2star(unit="m^2") "Critical Area at section-2";

//Equation
equation
A2star=(Astar_ratio)*A1f;

end Ex9_6_d;
//=================================================== 

model Ex9_6_e
extends Ex9_6_d;
extends Ex9_6_a;
extends Ex9_6_b;
extends Ex9_6_c;

//Variable
Real po3(unit="kPa") "Stagnation pressure at section-3";

//Equation
equation
po3=po2;

end Ex9_6_e; 
//===================================================

model Ex9_6_f
extends Ex9_6_e;
extends Ex9_6_a;
extends Ex9_6_b;
extends Ex9_6_c;
extends Ex9_6_d;

//Variable
Real A3star(unit="m^2") "Critical area of section-3";

//Equation
equation
A3star=A2star;

end Ex9_6_f;
//===================================================

model Ex9_6_h
extends Ex9_6_f;
extends Ex9_6_a;
extends Ex9_6_b;
extends Ex9_6_c;
extends Ex9_6_d;
extends Ex9_6_e;

//Variable
Real To3(unit="K") "Temperature at section-3";

//Equation
equation
To3=T;

end Ex9_6_h;
//===================================================

model Ex9_6_g
extends Ex9_6_h;
extends Ex9_6_a;
extends Ex9_6_b;
extends Ex9_6_c;
extends Ex9_6_d;
extends Ex9_6_e;
extends Ex9_6_f;

//Variable
Real Ma3(unit="-") "Mach number section-3";
Real p3(unit="kPa") "Pressure at section-3";

//Equation
equation
(A3/A3star)=((1/Ma3)*(1+0.2*Ma3*Ma3)^3)/(1.728);
p3=(po2)/(1+0.2*Ma3*Ma3)^3.5;

end Ex9_6_g;
//===================================================
end Ex9_6;
//===================================================
