//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.7 page-635
//Topic     : The Normal Shock Wave
//Caption   : An explosion in air creates spherical shock

//===================================================
package Ex9_7

model Ex9_7_a

//GIVEN: Fig E9.7
//Parameter
parameter Real k(unit="-") = 1.4            "Constant";
parameter Real p2(unit="lbf/in^2") = 200    "abs. Pressure inside shock";
parameter Real p1(unit="lbf/in^2") = 14.7   "abs. Pressure outside shock";
parameter Real T1(unit="deg.R") = 520       "Temperature";

//DATA: gas tables[16]
parameter Real cp(unit="ft^2/s^2.deg.R") = 6010 "Specific heat";


//Variable
Real p_ratio(unit="-")  "Pressure ratio";
Real Ma1(unit="-")      "Mach number";
Real V1(unit="ft/s")    "Outlet velocity";
Real a1(unit="ft/s")    "Speed of sound outside the shock";

//Equation
equation
p_ratio = (p2/p1); 

//USING: Eq. 9.55
p_ratio=(1/2.4)*(2.8*Ma1*Ma1-0.4);

a1=49*T1^0.5;
V1=Ma1*a1;

end Ex9_7_a;
//===================================================

model Ex9_7_b
extends Ex9_7_a;

//Variable Ex9_7_b
Real T2(unit="deg.R")   "Inlet temperature";
Real V2(unit="ft/s")    "Inlet velocity";
Real a2(unit="ft/s")    "Speed of sound inside the shock";
Real V(unit="ft/s")     "Air velocity";

//Equation Ex9_7_b
equation
//USING: Eq. 9.58
(T2/T1)*((k+1)*(k+1)*Ma1*Ma1)=(2+(k-1)*Ma1*Ma1)*((2*k*Ma1*Ma1)-(k-1));

//USING: Eq.9.23
(V2*V2)=(2*cp)*(T1-T2)+(V1*V1);
a2=(49)*(T2^0.5);
V=(V1-V2);

end Ex9_7_b;
//===================================================
end Ex9_7;
//===================================================
