//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.8 page-638
//Topic     : Operation of Converging and Diverging Nozzles
//Caption   : A converging nozzle

//===================================================
package Ex9_8
extends Modelica.Math;

model Ex9_8_a

//Parameter
parameter Real A(unit="cm^2") = 6   "Throat area";
parameter Real To(unit="K") = 400   "Air temperature";
parameter Real po(unit="kPa") = 120 "Air pressure";

//GIVEN:
parameter Real pa(unit="kPa") = 90  "Back pressure-a";
parameter Real pb(unit="kPa") = 45  "Back pressure-b";
parameter Real k(unit="-") = 1.4    "Constant";
parameter Real R(unit="m^2/s^2.K") = 287 "Air rate constant";


//Variable
Real pc(unit="kPa")     "Critical pressure";
Real Mae(unit="-")      "Mach number at exit";
Real p_ratio(unit="-")  "Exit/Inlet pressure ratio";
Real m(unit="kg/s")     "Mass flow rate-a";
Real pe1(unit="kPa")    "Exit pressure for part-A";


//Equation
equation
//USING: Eq. 9.32
(pc/po)=0.5283;
pe1=pa;

//By CONDITION: Exit pressure = Back pressure
//USING: Eq. 9.35
(Mae)=((5*(((po/pa)^(2/7))-1)))^0.5;

p_ratio=(pa/po);

//USING: Eq. 9.47
((m/((A/10000)*po))*((R*To)^0.5))=1000*((2*k/(k-1))*(p_ratio^(2/k))*(1-(p_ratio^((k-1)/k))))^(0.5);

end Ex9_8_a;
//===================================================

model Ex9_8_b
extends Ex9_8_a;

//Variable Ex9_8_b
Real m1(unit="kg/s") "Mass flow rate-b";
Real pe2(unit="kPa") "Exit pressure for part-B";

//Equation Ex9_8_b
equation
//USING: Eq. 9.46b
((m1/((A/10000)*po))*((R*To)^0.5))=1000*((2*k/(k-1))*((pc/po)^(2/k))*(1-((pc/po)^((k-1)/k))))^(0.5);
pe2=pc;

end Ex9_8_b;
//===================================================
end Ex9_8;
//===================================================
