//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.9 page-641
//Topic     : Operation of Converging and Diverging Nozzles
//Caption   : A Converging diverging nozzle

//===================================================
package Ex9_9

model Ex9_9_a

//Parameter 
parameter Real At(unit="m^2") = 0.002 "Throat area";
parameter Real Ae(unit="m^2") = 0.008 "Exit area";

parameter Real po(unit="kPa") = 1000    "Air pressure";
parameter Real To(unit="K") = 500       "Air temperature";

parameter Real pb_a(unit="kPa") = 300 "Back pressure-b";
parameter Real pb_c(unit="kPa") = 900 "Back pressure-c";

parameter Real k(unit="-") = 1.4            "Constant";
parameter Real R(unit="m^2/s^2.K") = 287    "Air rate constant";

//Variable
Real A_ratio(unit="-")      "Area ratio";
Real Ma(unit="-",start=2)   "Mach number";
Real p_ratio(unit="-")      "Pressure ratio";
Real pe_design(unit="kPa")  "Design pressure";
Real m_design(unit="kg/s")  "Mass flow rate";


//Equation Ex9_9_a

equation

A_ratio=(Ae/At);

//USING: Eq. 9.45
(A_ratio*Ma*1.728)=(1+(0.2*Ma*Ma))^3;

//USING: Eq. 9.34
p_ratio=(1+(0.2*Ma*Ma))^3.5;
pe_design=(po/p_ratio);
m_design=(0.6847*po*1000*At)/((R*To)^0.5);

end Ex9_9_a;
//===================================================

model Ex9_9_b
extends Ex9_9_a;

//Variable Ex9_9_b
Real ratio_p(unit="-")      "Pressure ratio";
Real p2(unit="kPa")         "Pressure section-2";
Real max_flow(unit="kg/s")  "Maximum flow rate for pb=300kPa";



//Equation Ex9_9_b
equation
//USING: Eq. 9.55
ratio_p=(1/(k+1))*((2*k*Ma*Ma)-(k-1));
p2=(pe_design*ratio_p);
max_flow=m_design;

end Ex9_9_b;
//===================================================

model Ex9_9_c
extends Ex9_9_b;
extends Ex9_9_a;

//Variable Ex9_9_c
Real Mae_C(unit="-")        "Mach number of section-c";
Real ratio_pe_c(unit="-")   "Isentropic exit pressure ratio";
Real pe_c(unit="kPa")       "Exit pressure ratio for section-C";
Real m_max_c(unit="kg/s")   "Maximum flow rate of section-C condition";


//Equation Ex9_9_c
equation
//USING: Eq. 9.48
A_ratio=(1/Mae_C)*((1+0.5*(k-1)*Mae_C^2)/0.5/(k+1))^(0.5*(k+1)/(k-1));
ratio_pe_c=(1+0.2*(Mae_C^2))^3.5;
po/pe_c=ratio_pe_c;
m_max_c=m_design;

end Ex9_9_c;
//===================================================
end Ex9_9;
//===================================================
