//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.13 page-47
//Topic     : Uncertainity in Experimental Data
//Caption   : The so-called dimensionless Moody pipe

//===================================================
model Ex1_13

//Parameter section

parameter Real D(unit="%")=0.5   "Pipe diameter";
parameter Real del_p(unit="%")=2 "Pressure drop";
parameter Real Rho(unit="%")=1   "Density";
parameter Real Q(unit="%")=3.5   "Volume flow rate";
parameter Real L(unit="%")=0.4   "Pipe length";


//===================================================

//Variable section

Real f(unit="%")     "Overall friction factor";


//===================================================

//Equation section

equation

// f = ((pi^2)*(Pipe diameter^5)*(Pressure drop))/(8*(Density)*(Volume flow rate^2)*(Length of pipe))

f = (((5*(D))^2)+(del_p^2)+(Rho)+((2*Q)^2)+(L^2))^(0.5);     //Friction factor

//===================================================
end Ex1_13;
//===================================================
