//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.6 page-25
//Topic     : Dimensions and Units
//Viscosity and Other Secondary Properties

//Caption   : The pressure at the deepest part of the ocean

//===================================================
model Ex1_6

//Parameter section

parameter Real P(unit="atm")=1100         "Pressure - deepest part of the ocean";
parameter Real B(unit="-")=3000         "Dimensionless parameter";
parameter Real n(unit="-")=7            "Dimensionless parameter";

//ASSUMING: Average density surface seawater
parameter Real rhoa(unit="slugs/ft^3")=2  "Average density of Sea Water";

//===================================================

//Variable section

Real RHO(unit="-")         "RHO = rho/rhoa";
Real rho(unit="slugs/ft^3")  "Density of sea water";

//===================================================

//Equation section

//Perfect Liquid Law:
//Pressure density relation for liquid : p/pa = (B+1)(rho/rhoa)^n - B
// B and n - Dimensionless parameters - vary with temperature 
// pa and rhoa - Standard atmospheric values

// GIVEN : P = p/pa

equation
//USING: Eq. 1.19
RHO = ((P+B)/(B+1))^(1/n);

rho = RHO * rhoa;
 
//=================================================== 
end Ex1_6;
//===================================================
