//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.1 page-708
//Topic      : Uniform flow; The Chezy Formula
//Caption    : A straight rectangular channel.

//===================================================
model Ex10_1
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;


//Parameter

//GIVEN: Fig E10.1
parameter Real b(unit="ft") = 6     "Width of channel";
parameter Real y(unit="ft") = 3     "Depth of channel";
parameter Real s(unit="deg.") = 2   "Slope of channel";
parameter Real f(unit="-") = 0.022  "Friction factor";

//===================================================

//Variable

Real C(unit="ft^0.5/s")     "Chezy coefficient";
Real A(unit="ft^2")         "Area of channel";
Real Rh(unit="ft")          "Hydraulic radius";
Real So(unit="deg.")        "Channel slope";
Real Q(unit="ft^3/s")       "Volumetric fow rate";

//===================================================

//Equation

equation

//USING: Eq. 10.13
C=(8*g/f)^0.5;
A=(b*y);
Rh=A/(b+y+y);
So=tan(s*(pi/180));
Q=(C*A)*(Rh^0.5)*(So^0.5);

//===================================================
end Ex10_1;
//===================================================
