//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.8 page-724
//Topic      : The Hydraulic Jump
//Caption    : Water flows in a wide channel and flow undergoes hydraulic jump

//===================================================
package Ex10_8
extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex10_8_a

//Parameter
parameter Real q(unit="m^3/s.m") = 10   "Volumetric flow rate per length";
parameter Real y1(unit="m") = 1.25      "Depth";
parameter Real cp(unit="J/kg.K") = 4200 "Specific heat";
parameter Real rho(unit="kg/m^3") = 1000 "Density of water";
//Variable
Real V1(unit="m/s") "Upstream velocity";
Real Fr1(unit="-")  "Upstream Froude number";
Real y2(unit="m")   "Downstream depth";

//Equation Ex10_8_a 
equation
V1=(q/y1);
Fr1=(V1)/((g*y1)^0.5);

//DATA: Fig 10.12 and Eq.10.43
(2*y2/y1)=(-1)+((1+(8*Fr1*Fr1))^0.5);

end Ex10_8_a;

//===================================================
model Ex10_8_b
extends Ex10_8_a;

//Variable Ex10_8_b
Real V2(unit="m/s") "Downstream velocity";

//Equation Ex10_8_b
equation
V2=(V1*y1/y2);

end Ex10_8_b;
//===================================================

model Ex10_8_c
extends Ex10_8_b;
extends Ex10_8_a;

//Variable Ex10_8_c
Real Fr2(unit="-") "Froude number downstream";

//Equation Ex10_8_c
equation
Fr2=(V2)/((g*y2)^0.5);
//Fr2 is subcritical condition

end Ex10_8_c;
//===================================================

model Ex10_8_d
extends Ex10_8_a;
extends Ex10_8_b;
extends Ex10_8_c;

//Variable Ex10_8_d
Real hf(unit="m") "Dissipation loss";

//Equation Ex10_8_d
equation
//USING: Eq.10.45
hf=((y2-y1)^3)/(4*y1*y2);

end Ex10_8_d;
//===================================================

model Ex10_8_e
extends Ex10_8_a;
extends Ex10_8_b;
extends Ex10_8_c;
extends Ex10_8_d;

//Variable Ex10_8_e
Real E1(unit="m") "Dissipation energy level";
Real p_loss(unit="%") "Percentage loss";

//Equation Ex10_8_e
equation
E1=(y1)+(V1*V1/(2*g));
p_loss=(hf/E1)*100;

end Ex10_8_e;
//===================================================

model Ex10_8_f
extends Ex10_8_a;
extends Ex10_8_b;
extends Ex10_8_c;
extends Ex10_8_d;
extends Ex10_8_e;

//Variable Ex10_8_f
Real P(unit="kW/m") "Power dissipated per unit width";

//Equation Ex10_8_f
equation
P=(rho*g*q*hf)/1000;

end Ex10_8_f;
//===================================================

model Ex10_8_g
extends Ex10_8_a;
extends Ex10_8_b;
extends Ex10_8_c;
extends Ex10_8_d;
extends Ex10_8_e;
extends Ex10_8_f;

//Variable
Real del_T(unit="K") "Temperature rise";

//Equation
equation
(P*1000)=(rho*q)*cp*(del_T);

end Ex10_8_g;
//===================================================
end Ex10_8;
//===================================================

//Remarks

//parameter     Textbook Value      Obtained Value
//Del_T         0.0015              0.001459
