//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.3 page-775
//Topic      : Pump Performance Curves and Similarity Rules
//Caption    : A pump from the family of given figure

//===================================================
package Ex11_3

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex11_3_a

//GIVEN: Fig. 11.8
//Parameter 
parameter Real D(unit="in") = 21        "Diameter of pump";
parameter Real n(unit="r/min") = 1500   "Rotation";

//DATA: Property of water at 60deg.F
parameter Real rho(unit="slugs/ft^3") = 1.94 "Density of water";

//DATA: Fig. 11.8 or Eqs. 11.27
parameter Real CQ(unit="-") = 0.115 "Capacity coefficient";
parameter Real CH(unit="-") = 5     "Head coefficient";
parameter Real Cp(unit="-") = 0.65  "Power coefficient";

//Variable
Real Q(unit="gal/min") "BEP discharge";

//Equation
equation
Q=(CQ*(n/60)*((D*0.0833)^3))*(448.8); //CONVERSION: in to ft
//CONVERSION: r/min to r/s
//CONVERSION: ft^3/s to gal/min

end Ex11_3_a;

//===================================================

model Ex11_3_b
extends Ex11_3_a;

//Variable
Real H(unit="ft-water") "BEP head";

//Equation
equation
H=((CH*((n/60)^2)*((D*0.0833)^2))/g);

end Ex11_3_b;

//===================================================

model Ex11_3_c
extends Ex11_3_b;
extends Ex11_3_a;

//Variable
Real del_p(unit="lbf/in^2") "Pressure drop";

//Equation
equation
del_p=(rho*g*H*(0.0833*0.0833));

end Ex11_3_c;

//===================================================
model Ex11_3_d
extends Ex11_3_a;
extends Ex11_3_b;
extends Ex11_3_c;

//Variable
Real P(unit="hp") "BEP power";

//Equation
equation
(P*550)=Cp*rho*((n/60)^3)*((D*0.0833)^5); //Conversion to hp

end Ex11_3_d;

//===================================================
end Ex11_3;
//===================================================
