//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.5 page-778
//Topic      : Mixed and Axial Flow Pumps: The Specific Speed
//Caption    : Centrifugal pump to deliver water

//===================================================
package Ex11_5

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex11_5_a

//Parameter
parameter Real Q(unit="gal/min") = 100000   "Flow rate of water";
parameter Real H(unit="ft") = 25            "Pump head";

//DATA: Fig. 11.8 or Eqs. 11.27
parameter Real CQ(unit="-") = 0.115 "Capacity coefficient";
parameter Real CH(unit="-") = 5     "Head coefficient";
parameter Real Cp(unit="-") = 0.65  "Power coefficient";

//DATA: Property of water at 60deg.F
parameter Real rho(unit="slugs/ft^3") = 1.94 "Density of water";

//Variable
Real N(unit="r/s")    "Revolution of impeller";
Real D(unit="ft")     "Diameter of impeller";
Real n(unit="r/min")  "Revolution of impeller";

//Equation
equation
//USING: Eq. 11.27
H=CH*(N*N)*(D*D)/g;
(Q*0.00222801)=(CQ*N*D*D*D); //CONVERSION: gal/min to ft^3/s
n=(N*60);

end Ex11_5_a;
//===================================================

model Ex11_5_b
extends Ex11_5_a;

//Variable
Real bhp(unit="hp") "Horse power";

//Equation
equation
//USING: Eq. 11.27
(bhp*550)=(Cp*rho)*(N^3)*(D^5);
//CONVERSION: to hp

end Ex11_5_b;
//===================================================
end Ex11_5;
//===================================================
