//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.7 page-792
//Topic      : Matching Pumps to System Characteristics
//Caption    : Two 32in pumps in parallel

//===================================================
model Ex11_7

//EXTENDING: Example 11.6
//Parameter 
parameter Real D(unit="in") = 32        "Diameter of impeller";
parameter Real n(unit="r/min") = 1170   "Revolution";
parameter Real L(unit="ft") = 1500      "Length of pipe";
parameter Real D_pipe(unit="in") = 16   "Diameter of pipe";
parameter Real f(unit="-") = 0.030      "Friction factor pipe";
parameter Real z1(unit="ft") = 120      "Height of point-1";
parameter Real z2(unit="ft") = 0        "Height of point-2";

//===================================================

//Variable

Real Q(unit="gal/min") "Volumetric flow rate";

//===================================================

//Equation

equation

(Q*Q)=((490-z1)/(1.335+0.065))*(10^6);

//===================================================
end Ex11_7;
//===================================================

//Remarks
//Parameter     Textbook Value      Obtained Value
//Q(gal/min)    16300               16256.9

//===================================================
