//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.1 page-71
//Topic     : Hydrostatic Pressure Distributions
//Caption   : Freshwater lake near Bristol

//===================================================
model Ex2_1

// Parameters

parameter Real d(unit="m") = 60         "Maximum depth of freshwater lake";
parameter Real p(unit="kPa") = 91       "Mean Atmospheric pressure";
parameter Real spw(unit="N/m^2") = 9790 "Specific Gravity of Water";
parameter Real z(unit="m") = 0          "Reference Height";

//===================================================
// Variables

Real Ap(unit="kPa") "Absolute Pressure in maximum depth";

//===================================================
// Equation

equation

//Applying the pressure in Pa 'unit' and then converting it to kPa 
Ap = ((p*1000)-((spw)*(-d)))/(1000); //Absolute pressure at the maximum depth

//===================================================
end Ex2_1;
//===================================================
