//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.11 page-93
//Topic     : Buoyancy and Stability
//Caption   : A block of concrete immersed in fresh water
//===================================================
model Ex2_11

//Parameter
parameter Real W(unit="lbf") = 100 "Weight of concrete in air";
parameter Real W2(unit="lbf") = 60 "Weight of concrete in fresh water";
parameter Real rho(unit="lbf/ft^3") = 62.4 "Density of water";

//Variable
Real FB(unit="lbf") "Buoyant force";
Real rhoB(unit="lbf/ft^3") "Specific weight of block";

//Equation
equation
FB=(W-W2); 
rhoB=(W/(FB/rho));

//===================================================
end Ex2_11;
//===================================================
