//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.14 page-101
//Topic     : Hydrostatic Forces on Plane surfaces
//Caption   : Coffe cup removed from drag racer, placed on turntable.

//===================================================
package Ex2_14

model Ex2_14_a

//Parameter 
parameter Real hi(unit="cm") = 7 "Height of coffee in cup";
parameter Real ho(unit="cm") = 3 "Height remaining till lip";
parameter Real g(unit="m/s^2") = 9.81 "Gravity acceleration";
parameter Real rho(unit="kg/m^3") = 1010 "Density of coffee";


//Variable
Real sig(unit="rad^2/s^2") "Angular velocity";

//Equation 
equation
sig = (((4*g)/(ho/100)));

end Ex2_14_a;
//===================================================
model Ex2_14_b

extends Ex2_14_a;

//Variable
Real pA(unit="Pa") "Pressure";

//Equation
equation
pA=((-rho*g)*(-0.04)+(0.5*rho*((3/100)^2)*(sig)));

end Ex2_14_b;
//===================================================
end Ex2_14;
//===================================================
