//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.4 page-78
//Topic     : Application to Manometry
//Caption   : Pressure gage to measure pressure

//===================================================
model Ex2_4

extends Modelica.Math;

// Parameters
parameter Real pb(unit ="kPa") = 87           "Pressure at point B";
parameter Real rho1(unit ="N/m^2")  = 9790    "Density of water";
parameter Real rho2(unit ="N/m^2") = 133100   "Density of mercury";
parameter Real rho3(unit = "N/m^2") = 8720    "Density of oil";
parameter Real delzw(unit = "cm") = 5         "Water distance in the column";
parameter Real delzm(unit = "cm")= 7          "Mercury distance in the column";
parameter Real delzo(unit = "cm")= 6          "SAE 30 oil distance in the column";

//===================================================

// Variables
Real pa(unit = "kPa")                         "Pressure at point A";

//===================================================

// Equations
equation
pa = ((pb*1000)-(rho1*(delzw/100))+(rho2*(delzm/100))+(rho3*(delzo/100)))/(1000);

//===================================================
end Ex2_4;
//===================================================
