//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.6 page-84
//Topic     : Hydrostatic Forces on plane surfaces
//Caption   : Pressure distribution on a plate
//===================================================
package Ex2_6

model Ex2_6_a
extends Modelica.Math;

//Parameter
parameter Real rho(unit="lbf/ft^3") = 64 "Density of water";
parameter Real hA(unit="ft") = 9 "point-A 9ft deep";
parameter Real hB(unit="ft") = 15 "point-B 15ft deep";
parameter Real len(unit="ft") = 10 "Length of the rectangle";
parameter Real wid(unit="ft") = 5 "Width of the rectangle";

//Variable
Real pA(unit="lbf/ft^2") "Pressure at point-A";
Real pB(unit="lbf/ft^2") "Pressure at point-B";
Real F(unit="lbf") "Total force";

//Equation
equation
pA=(rho*hA);
pB=(rho*hB);
F = (pA*len*wid)+(((pB-pA)/2)*len*wid);

end Ex2_6_a;
//===================================================

model Ex2_6_b
extends Ex2_6_a;
extends Modelica.Math;

// Variable
Real Ma(unit="ft.lbf") "Moments of forces about point-A";
Real l(unit="ft") "Center of pressure";

//Equation
equation
Ma=(pA*len*wid*wid)+(((pB-pA)/2)*len*wid*6.67); //Centroid of trianlge=6.67
l=(Ma/F)-(wid);

end Ex2_6_b;

//===================================================
end Ex2_6;
//===================================================
