//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.8 page-87
//Topic     : Hydrostatic Forces on Curved surfaces
//Caption   : A dam has parabolic shape
//===================================================

model Ex2_8
extends Modelica.Math;

//Parameter
parameter Real xo(unit="ft") = 10 "Distance";
parameter Real zo(unit="ft") = 24 "Distance from top";
parameter Real rho(unit="lbf/ft^3") = 62.4 "Density of water";
parameter Real b(unit="ft") = 50 "Width of the dam";

//Variable
Real hCG(unit="ft") "Centroid of dam";
Real A(unit="ft^2") "Area of projection";
Real FH(unit="lbf") "Horizontal force";
Real FV(unit="lbf") "Vertical force";
Real yCP(unit="ft") "Line of action of force FH";
Real Ixx(unit="ft") "Inertial force-xx";
Real F(unit="lbf") "Resultant hydrostatic force on dam";

//Equation
equation
hCG=zo/2; //Centroid of dam
A=(b*zo); //Projected area
FH=(rho*A*hCG); //Horizontal force
Ixx=(1/12)*(b);
yCP=(-Ixx*(zo^3)*sin(90*(3.14/180)))/(hCG*A);
FV=(rho*zo*xo*b*(2/3));
F=((FH^2)+(FV^2))^(0.5);

end Ex2_8;
