//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.18 page-181
//Topic     : the Angular Momentum Theorem
//Caption   : Centrifugal Pump.

//===================================================
model Ex3_18
extends Modelica.Math;

//Parameter
parameter Real r1(unit="m") = 0.2 "Inner radius";
parameter Real r2(unit="m") = 0.5 "Outer radius";
parameter Real b(unit="m") = 0.15 "Width";
parameter Real R(unit="r/min") = 600 "Rotational velocity";
parameter Real Q(unit="m^3/s") = 2.5 "Volumetric flow rate";
parameter Real rho(unit="kg/m^3") = 1000 "Density of water";

final constant Real pi=2*Modelica.Math.asin(1.0); //3.14159265358979;

//Variable
Real R1(unit="rad/s") "Rotational velocity"; //Unit conversion from r/min to rad/s
Real Vn1(unit="m/s") "Velocity-inlet";
Real Vn2(unit="m/s") "Velocity-outlet";
Real Vr1(unit="m/s") "Idealised velocity-intlet";
Real Vr2(unit="m/s") "Idealised velocity-outlet";
Real To(unit="N.m") "Torque";
Real P(unit="MW") "Power";

//Equation
equation
R1=(R*((2*pi)/60)); //Unit Conversion
Vn1=(Q/(2*pi*r1*b));
Vn2=(Q/(2*pi*r2*b));
Vr1=(R1*r1);
Vr2=(R1*r2);
To=((rho*Q)*((r2*Vr2)-(r1*Vr1)));
P=((R1*To)/1000000);

//===================================================
end Ex3_18;
//===================================================

//Answer variation
//Parameter     Obtained    Textbook Answer
//Vn1(m/s)      13.2627     13.3
//Vr1(m/s)      12.566      12.6
//To(N.m)       32986.7     33000
