//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.22 page-190
//Topic     : The Energy Equation
//Caption   : Air flows steadily through a turbine.

//===================================================
package Ex3_22


model Ex3_22_a
extends Modelica.Math;

//Parameter
parameter Real R(unit="ft.lbf/slug.deg.R") = 1716 "Perfect gas constant";
parameter Real cp(unit="lbf/slug.deg.R") = 6003 "Specific heat";
parameter Real Ws(unit="hp") = 700 "turbine work";

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Given: In figure E3.22
parameter Real D1(unit="in") = 6 "Diameter-inlet";
parameter Real D2(unit="in") = 6 "Diameter-outlet";
parameter Real p1(unit="lb/in^2") = 150 "Pressure-inlet";
parameter Real p2(unit="lb/in^2") = 40 "Pressure-outlet";
parameter Real T1(unit="Deg.F") = 300 "Temperature-inlet ";
parameter Real T2(unit="Deg.F") = 35 "Temperature-outlet ";
parameter Real V1(unit="ft/s") = 100 "Velocity-inlet ";

//Variable
Real V2(unit="ft/s") "Velocity-outlet";
Real rho1(unit="slug/ft^3") "Density-inlet";
Real rho2(unit="slug/ft^3") "Density-outlet";
Real m(unit="slug/s") "Mass flow rate";
Real A1(unit="ft^2") "Area-inlet";

//Equation
equation
A1=(pi/4)*((D1/12)^2); // Conversion in to ft
rho1=(p1*144)/(R*(T1+460)); // Conversion of in^2 to ft^2 // Conversion of deg.F to deg.R
rho2=(p2*144)/(R*(T2+460)); // Conversion of in^2 to ft^2 // Conversion of deg.F to deg.R
m=(rho1*A1*V1);
m=(rho2*A1*V2);

 //===================================================
end Ex3_22_a;
//===================================================

model Ex3_22_b
extends Ex3_22_a;

//Conversion
//(1 hp = 550 ft.lbf/s)

//Variable
Real q(unit="lbf/s") "Heat transfer rate";
Real Q(unit="Btu/h") "Heat transfer rate";


//Equation 
equation
(q-(Ws*550)) = (m)*((cp*(T2+460))+(0.5*V2^2)-(cp*(T1+460))-(0.5*V1^2));

Q=(q)*(3600/778.2); //Unit conversion lbf/s to Btu/hr

//===================================================
end Ex3_22_b;
//===================================================

//===================================================
end Ex3_22;
//===================================================
