//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 5 : Dimensional Analysis and Similarity
//Example   : 5.11 page-331
//Topic     : Modeling and its Pitfalls 
//Caption   : The smooth sphere.

//===================================================

model Ex5_11

//Parameter
parameter Real rho_w(unit="kg/m^3") = 998 "Density-water";
parameter Real gamma_s(unit="-") = 7.86 "Specific gravity-steel";
parameter Real d(unit="cm") = 1 "Diameter-steel ball";
parameter Real mew_w(unit="kg/m.s") = 0.001 "Viscosity-water";

final constant Real g(unit="m/s^2") = 9.81 "Gravity-acceleration";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Data: Fig2 5.11
parameter Real Rey(unit="-") = 20000 "Reynolds number";

//===================================================

//Variable

Real rho_s(unit="kg/m^3") "Density-steel";
Real F(unit="N") "Drag force";
Real Ord(unit="-") "Ordinate-falling steel sphere";
Real V(unit="m/s") "Terminal fall velocity";

//===================================================

//Equation

equation

rho_s=(gamma_s*rho_w);

//Given: Drag force = Net weight
F=(rho_s-rho_w)*(g)*(pi/6)*((d/100)^3);

//Data: Figure 5.11
Ord=(rho_w*F)/(mew_w^2);
//Given: Reynolds number = 20000
V=(Rey*mew_w)/(rho_w*(d/100));

//===================================================
end Ex5_11;
//===================================================
