//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.12 page-379
//Topic     : Flow in Noncircular Ducts
//Caption   : A pump delivers water flowing in a asphalted cast iron pipe

//===================================================
model Ex6_12
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

parameter Real P(unit="hp") = 0.6   "Power-pump";
parameter Real d(unit="in") = 6     "Diameter-pipe";
parameter Real V(unit="ft/s") = 6   "Velocity";

//Data Given: Water property at 68deg.F from TABLE A.3
parameter Real rho(unit="slug/ft^3") = 1.94         "Density-water";
parameter Real mew(unit="slug/ft.s") = 0.0000209    "Viscosity-water";

//From TABLE 6.1
parameter Real e(unit="ft") = 0.0004 "Pipe roughness";

//===================================================

//Variable

Real Q(unit="ft^3/s")   "Flow rate";
Real h_pump(unit="ft")  "Pump head";
Real rey(unit="-")      "Reynolds number";
Real ratio(unit="-")    "Ratio: e/d";
Real f(unit="-")        "Friction factor";
Real L(unit="ft")       "Pipe-length";
//===================================================
//Equation

equation

Q =(pi/4)*((d*(0.0833))^(2))*(V);
h_pump=(P*550)/(rho*g*Q); //Unit conversion in to ft
//Unit conversion hp to lbf.ft/s

//USING: Eq. 6.48
rey=(rho*V*(d*0.0833))/mew;
ratio=(e/(d*0.0833));
(f^(-0.5))=((-2)*log10((ratio/3.7)+(2.51/(rey*(f^0.5)))));
//Using Darcy formula

//USING: Eq.6.10
h_pump=(f*L*V*V)/((d*0.0833)*2*g);

//===================================================
end Ex6_12;
//===================================================
