//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.18 page-400
//Topic     : Multiple-Pipe Systems
//Caption   : Pipes in parallel to calculating total flow rate 

//===================================================
model Ex6_18
extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real p_d(unit="Pa") = 150000 "Total pressure drop";
parameter Real z_d(unit="m") = 5 "Elevation drop";
parameter Real rho(unit="kg/m^3") = 1000 "Density-Water";
parameter Real v(unit="m^2/s") = 0.00000102 "Kinematic viscosity-water";
parameter Real del_h(unit="m") = 20.3 "Total head loss";


//GIVEN: Fig. 6.24a
//DATA: Given
parameter Real L1(unit="m") = 100 "Length-pipe1";
parameter Real L2(unit="m") = 150 "Length-pipe2";
parameter Real L3(unit="m") = 80 "Length-pipe3";

parameter Real d1(unit="cm") = 8 "Diameter-pipe1";
parameter Real d2(unit="cm") = 6 "Diameter-pipe2";
parameter Real d3(unit="cm") = 4 "Diameter-pipe3";

parameter Real e1(unit="mm") = 0.24 "Roughness-pipe1";
parameter Real e2(unit="mm") = 0.12 "Roughness-pipe2";
parameter Real e3(unit="mm") = 0.20 "Roughness-pipe3";

//DATA: Guess values - pipe1
parameter Real f1_1(unit="-") = 0.0262 "Friction factor-pipe1-Guess1";
parameter Real f1_2(unit="-") = 0.0267 "Friction factor-pipe1-Guess2";

//DATA: Guess values - pipe2
parameter Real f2_1(unit="-") = 0.0234 "Friction factor-pipe2-Guess1";
parameter Real f2_2(unit="-") = 0.0246 "Friction factor-pipe2-Guess2";

//DATA: Guess values - pipe3
parameter Real f3_1(unit="-") = 0.0304 "Friction factor-pipe2-Guess1";
parameter Real f3_2(unit="-") = 0.0313 "Friction factor-pipe2-Guess2";

//===================================================

//Variable

Real V1_1(unit="m/s") "Velocity-water-pipe1-for f1_1";
Real V1_2(unit="m/s") "Velocity-water-pipe1-for f1_2";
Real rey1_1(unit="-") "Reynolds number-pipe1-for f1_1";
Real Q1(unit="m^3/h") "Volumetric flow rate-pipe1";

Real V2_1(unit="m/s") "Velocity-water-pipe2-for f2_1";
Real V2_2(unit="m/s") "Velocity-water-pipe2-for f2_2";
Real rey2_1(unit="-") "Reynolds number-pipe2-for f2_1";
Real Q2(unit="m^3/h") "Volumetric flow rate-pipe2";

Real V3_1(unit="m/s") "Velocity-water-pipe3-for f3_1";
Real V3_2(unit="m/s") "Velocity-water-pipe3-for f3_2";
Real rey3_1(unit="-") "Reynolds number-pipe3-for f3_1";
Real Q3(unit="m^3/h") "Volumetric flow rate-pipe3";

Real Q(unit="m^3/h") "Total volumetric flow rate";

//===================================================

//Equation

equation

del_h=((((V1_1)^2)/(2*g))*(f1_1*L1/(d1/100)));
del_h=((((V1_2)^2)/(2*g))*(f1_2*L1/(d1/100)));
rey1_1=((V1_1*(d1/100))/v);
(Q1/3600)=(pi/4)*((d1/100)^2)*(V1_2);

del_h=((((V2_1)^2)/(2*g))*(f2_1*L2/(d2/100)));
del_h=((((V2_2)^2)/(2*g))*(f2_2*L2/(d2/100)));
rey2_1=((V2_1*(d2/100))/v);
(Q2/3600)=(pi/4)*((d2/100)^2)*(V2_2);

del_h=((((V3_1)^2)/(2*g))*(f3_1*L3/(d3/100)));
del_h=((((V3_2)^2)/(2*g))*(f3_2*L3/(d3/100)));
rey3_1=((V3_1*(d3/100))/v);
(Q3/3600)=(pi/4)*((d3/100)^2)*(V3_2);

Q=(Q1+Q2+Q3);

//===================================================
end Ex6_18;
//===================================================
