//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.20 page-413
//Topic     : Fluid Meters
//Caption   : The pitot static tube uses mercury as manometric fluid

//===================================================
model Ex6_20

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";

//Parameter
parameter Real h(unit="in") = 8.4 "Manometer height reading";

//DATA: Table 2.1
parameter Real sgm(unit="lbf/ft^3") = 846 "Specific gravity-mercury";
parameter Real sgw(unit="lbf/ft^3") = 62.4 "Specific gravity-water";

//===================================================

//Variable

Real rhow(unit="slug/ft^3") "Density-water";
Real pdiff(unit="lbf/ft^2") "Pressure difference";
Real V(unit="ft/s") "Velocity";

//===================================================

//Equation

equation

rhow=(sgw/g);
pdiff=(sgm-sgw)*(h*0.0833);
(V^2)=(2/rhow)*(pdiff);

//===================================================
end Ex6_20;
//===================================================
