//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.22 page-429
//Topic     : Fluid Meters
//Caption   : A long radius nozzle of diameter is used to meter air flow

//===================================================
model Ex6_22

extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real d(unit="cm") = 6         "Diameter-nozzle";
parameter Real D(unit="cm") = 10        "Diameter-pipe";
parameter Real p1(unit="kPa") = 200     "Pressure-upstream";
parameter Real T1(unit="deg.C") = 100   "Temperature-upstream";
parameter Real pdrop(unit="kPa") = 60   "Pressure drop-nozzle";

//GIVEN: Table A.2
parameter Real mew(unit="kg/m.s") = 0.0000217 "Pressure drop-nozzle";

//Given: Fig. 6.42
parameter Real Cd(unit="-") = 0.98  "Discharge coefficient";
parameter Real Cd1(unit="-") = 0.99 "Discharge coefficient";


//Given: Fig. 6.45
parameter Real Y(unit="-") = 0.80 "Compressible flow expansion factor";

//===================================================

//Variable

Real beta(unit="-")         "Diameter ratio";
Real rho1(unit="kg/m^3")    "Density-air-point1";
Real p2(unit="kPa")         "Pressure-downstream";
Real ratio(unit="-")        "Pressure ratio - p2/p1";
Real m(unit="kg/s")         "Mass flow rate";
Real rey(unit="-")          "Reynolds number";
Real m1(unit="kg/s")        "Mass flow rate for Cd1";

//===================================================

//Equation

equation

beta=(d/D);
rho1=(p1*1000)/((T1+273)*(287));
p2=(p1-pdrop);
ratio=(p2/p1);


m=((Cd*Y)*((pi/4)*((d/100)^2)))*(((2*rho1*(pdrop*1000))/(1-beta^4))^0.5);

rey=(4*m)/(pi*mew*(d/100));

m1=((Cd1*Y)*((pi/4)*((d/100)^2)))*(((2*rho1*(pdrop*1000))/(1-beta^4))^0.5);

//===================================================
end Ex6_22;
//===================================================
