//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.3 page-357
//Topic     : Laminar Fully Developed Pipe Flow
//Caption   : Oil flows upward in an inclined pipe

//===================================================
package Ex6_3
extends Modelica.Math;

model Ex6_3_a

//Parameter 
parameter Real rho(unit="kg/m^3") = 900 "Density-oil";
parameter Real v(unit="m^2/s") = 0.0002 "Kinematic viscosity-oil";
parameter Real del_L(unit="m") = 10     "Distance-point1&2";

final constant Real g(unit="m/s^2") = 9.807 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Given: Fig. E6.3
parameter Real d(unit="cm") = 6         "Diameter-pipe";
parameter Real p1(unit="Pa") = 350000   "Pressure-point-1";
parameter Real p2(unit="Pa") = 250000   "Pressure-point-2";
parameter Real angle(unit="deg.C") = 40 "Angle-inclination";
parameter Real z1(unit="m") = 0         "Distance-point1";

//===================================================

//Variable Ex6_3_a

Real mew(unit="kg/m.s") "Viscosity-oil";
Real z2(unit="m")       "Distance-point2";
Real HGL1(unit="m")     "Hydraulic grade-line height-1";
Real HGL2(unit="m")     "Hydraulic grade-line height-2";

//Equation Ex6_3_a

equation

mew=(rho*v);
z2=(del_L*sin(angle*(pi/180)));
HGL1=(z1)+(p1/(rho*g));
HGL2=(z2)+(p2/(rho*g));

//===================================================
end Ex6_3_a;
//===================================================

model Ex6_3_b
extends Ex6_3_a;

//Variable Ex6_3_b
Real hf(unit="m") "Head loss";

//Equation Ex6_3_b

equation
hf=(HGL1-HGL2);

//===================================================
end Ex6_3_b;
//===================================================

model Ex6_3_c
extends Ex6_3_a;
extends Ex6_3_b;

//Variable Ex6_3_c
Real Q(unit="m^3/s") "Volumetric flow rate";

//Equation Ex 6_3_c
equation
Q =(pi*rho*g*hf*((d/100)^4))/(128*mew*del_L);

//===================================================
end Ex6_3_c;
//===================================================

model Ex6_3_d
extends Ex6_3_a;
extends Ex6_3_b;
extends Ex6_3_c;

//Variable Ex6_3_d
Real V(unit="m/s") "Average velocity";

//Equation Ex6_3_d
equation
V=(Q/(pi*(((d/2)/100)^2)));

//===================================================
end Ex6_3_d;
//===================================================

model Ex6_3_e
extends Ex6_3_a;
extends Ex6_3_b;
extends Ex6_3_c;
extends Ex6_3_d;

//Variable Ex6_3_e
Real rey(unit="-") "Reynolds number";

//Equation Ex 6_3_e
equation
rey = (V*(d/100))/v;

//===================================================
end Ex6_3_e;
//===================================================
//===================================================
end Ex6_3;
//===================================================
